/*
 * Decompiled with CFR 0.152.
 */
package boone;

import boone.BrainPart;
import boone.NeuralNet;
import boone.Neuron;
import boone.util.Common;
import boone.util.Xml;
import org.jdom2.Element;

public class Link
extends BrainPart {
    protected Neuron source;
    protected Neuron sink;
    protected double value;
    private boolean directed = true;

    public Link() {
    }

    public Link(double d) {
        this();
        this.weight = d;
    }

    public Link(Neuron neuron, Neuron neuron2, double d) {
        this(d);
        this.setSource(neuron);
        this.setSink(neuron2);
    }

    @Override
    public Link clone() {
        Link link = (Link)super.clone();
        link.setID(-1L);
        link.source = null;
        link.sink = null;
        return link;
    }

    public Neuron getSource() {
        return this.source;
    }

    public Neuron setSource(Neuron neuron) {
        Neuron neuron2 = this.source;
        if (neuron != this.source) {
            if (this.source != null) {
                this.source.links.remove(this);
            }
            if (neuron != null) {
                neuron.links.add(this);
            }
            this.source = neuron;
        }
        return neuron2;
    }

    public void clearSource() {
        this.sink = null;
    }

    public Neuron getSink() {
        return this.sink;
    }

    public Neuron setSink(Neuron neuron) {
        Neuron neuron2 = this.sink;
        if (neuron != this.sink) {
            if (this.sink != null) {
                this.sink.links.remove(this);
            }
            if (neuron != null) {
                neuron.links.add(this);
            }
            this.sink = neuron;
        }
        return neuron2;
    }

    public void clearSink() {
        this.sink = null;
    }

    public boolean isDangling() {
        return this.source == null || this.sink == null;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double d) {
        this.value = d;
    }

    public boolean isDirected() {
        return this.directed;
    }

    public void setDirected(boolean bl) {
        this.directed = bl;
    }

    public void disconnect() {
        this.setSource(null);
        this.setSink(null);
    }

    public void propagate() {
        this.value = this.source.getOutput() * this.weight;
        this.sink.addLinkInput(this);
    }

    public Neuron getOtherNeuron(Neuron neuron) {
        if (this.source == neuron) {
            return this.sink;
        }
        if (this.sink == neuron) {
            return this.source;
        }
        return null;
    }

    public void replaceNeuron(Neuron neuron, Neuron neuron2) {
        if (this.source == neuron) {
            this.setSource(neuron2);
        } else if (this.sink == neuron) {
            this.setSink(neuron2);
        }
    }

    public void replaceFrom(Link link) {
        this.setSource(link.getSource());
        this.setSink(link.getSink());
        this.setID(link.getID());
        link.setSource(null);
        link.setSink(null);
    }

    public boolean isInputOf(Neuron neuron) {
        return this.sink == neuron || !this.directed;
    }

    public boolean isOutputOf(Neuron neuron) {
        return this.source == neuron || !this.directed;
    }

    @Override
    public Element toXML(Element element) {
        Element element2 = Xml.addStorable(element, "link", this);
        super.toXML(element2);
        if (!this.directed) {
            element2.setAttribute("di", String.valueOf(false));
        }
        element2.setAttribute("so", String.valueOf(this.source.getID()));
        element2.setAttribute("si", String.valueOf(this.sink.getID()));
        return element2;
    }

    public void fromXML(Element element, NeuralNet neuralNet) {
        this.directed = true;
        if (Xml.hasAttributeValue(element, "di")) {
            this.directed = Xml.getProperty(element, "di", true);
        } else if (Xml.hasAttributeValue(element, "undirected")) {
            this.directed = !Xml.getProperty(element, "undirected", false);
        }
        long l = Xml.getDualProperty(element, "so", "source", -1L);
        this.setSource(neuralNet.getNeuronID(l));
        l = Xml.getDualProperty(element, "si", "sink", -1L);
        this.setSink(neuralNet.getNeuronID(l));
    }

    @Override
    public String toString() {
        return "[" + this.getName() + " " + this.getID() + ": w = " + Common.fixedPoint.format(this.getWeight()) + "]";
    }
}

