/*
 * Decompiled with CFR 0.152.
 */
package boone;

import boone.io.Storable;
import boone.map.Function;
import boone.util.Common;
import boone.util.Xml;
import org.jdom2.Element;

public abstract class BrainPart
implements Cloneable,
Storable {
    public static final long NO_ID = -1L;
    private static long uniqueID;
    protected String name = "";
    private long ID = -1L;
    private boolean trainable = true;
    protected double weight;
    private double gradient;
    private double lastGradient;
    private double accu;
    protected Function activationFn;

    public void calculate() {
    }

    public void reset() {
        this.gradient = 0.0;
        this.lastGradient = 0.0;
        this.accu = 0.0;
    }

    public static long getUniqueID() {
        if (uniqueID < 0L) {
            System.out.println("Boone Panic! New ID < 0, too many BrainParts!");
        }
        return uniqueID++;
    }

    public boolean isTrainable() {
        return this.trainable;
    }

    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double d) {
        this.weight = d;
    }

    public void addToWeight(double d) {
        this.weight += d;
    }

    public void setTrainable(boolean bl) {
        this.trainable = bl;
    }

    public Function getActivationFn() {
        return this.activationFn;
    }

    public void setActivationFn(Function function) {
        this.activationFn = function;
    }

    public double getGradient() {
        return this.gradient;
    }

    public void setGradient(double d) {
        this.gradient = d;
    }

    public void addGradient(double d) {
        this.gradient += d;
    }

    public double getLastGradient() {
        return this.lastGradient;
    }

    public void setLastGradient(double d) {
        this.lastGradient = d;
    }

    public double getAccu() {
        return this.accu;
    }

    public void setAccu(double d) {
        this.accu = d;
    }

    public void randomize() {
        this.randomize(-0.1, 0.1);
    }

    public void randomize(double d, double d2) {
        this.weight = Common.getRandom(d, d2);
    }

    @Override
    public Element toXML(Element element) {
        if (this.name != null && !this.name.equals("")) {
            element.setAttribute("name", this.name);
        }
        element.setAttribute("id", String.valueOf(this.ID));
        element.setAttribute("we", String.valueOf(this.getWeight()));
        return element;
    }

    @Override
    public void fromXML(Element element) {
        this.name = Xml.getProperty(element, "name", this.name);
        this.ID = Xml.getProperty(element, "id", -1L);
        this.weight = Xml.getDualProperty(element, "we", "weight", this.weight);
    }

    public BrainPart clone() {
        BrainPart brainPart = null;
        try {
            brainPart = (BrainPart)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return brainPart;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public long getID() {
        return this.ID;
    }

    public void setID(long l) {
        this.ID = l;
    }
}

