/*
 * Decompiled with CFR 0.152.
 */
package boone;

import boone.NeuralNet;
import boone.PatternSet;
import boone.io.BooneFilter;
import boone.io.Storable;
import boone.util.CloneException;
import boone.util.Xml;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jdom2.Element;

public class Brain
implements Storable,
Cloneable {
    protected ArrayList<NeuralNet> nets = new ArrayList();
    protected ArrayList<PatternSet> patternSets = new ArrayList();
    protected Properties props = new Properties();

    public Brain clone() {
        try {
            int n;
            Brain brain = (Brain)super.clone();
            brain.nets = new ArrayList();
            for (n = 0; n < this.nets.size(); ++n) {
                brain.nets.add(this.nets.get(n).clone());
            }
            brain.patternSets = new ArrayList();
            for (n = 0; n < this.patternSets.size(); ++n) {
                brain.patternSets.add(this.patternSets.get(n).clone());
            }
            brain.props = (Properties)this.props.clone();
            return brain;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new CloneException(cloneNotSupportedException);
        }
    }

    public int getNetCount() {
        return this.nets.size();
    }

    public NeuralNet getNet(int n) {
        return this.nets.get(n);
    }

    public void addNet(NeuralNet neuralNet) {
        this.nets.add(neuralNet);
    }

    public void addNet(int n, NeuralNet neuralNet) {
        this.nets.add(n, neuralNet);
    }

    public void removeNet(int n) {
        this.nets.remove(n);
    }

    public void removeNet(NeuralNet neuralNet) {
        this.nets.remove(neuralNet);
    }

    public void clearNets() {
        this.nets.clear();
    }

    public int getSetCount() {
        return this.patternSets.size();
    }

    public PatternSet getSet(int n) {
        return this.patternSets.get(n);
    }

    public void addSet(PatternSet patternSet) {
        this.patternSets.add(patternSet);
    }

    public void addSet(int n, PatternSet patternSet) {
        this.patternSets.add(n, patternSet);
    }

    public void removeSet(int n) {
        this.patternSets.remove(n);
    }

    public void removeSet(PatternSet patternSet) {
        this.patternSets.remove(patternSet);
    }

    public void clearSets() {
        this.patternSets.clear();
    }

    public void save(File file) throws IOException {
        new BooneFilter(file, "brain").save(this);
    }

    @Override
    public void fromXML(Element element) {
        List list = element.getChildren();
        for (Object object : list) {
            Cloneable cloneable;
            if (object.getName().equals("net") && (cloneable = (NeuralNet)Xml.getStorable((Element)object)) != null) {
                this.addNet((NeuralNet)cloneable);
            }
            if (!object.getName().equals("set") || (cloneable = (PatternSet)Xml.getStorable((Element)object)) == null) continue;
            this.addSet((PatternSet)cloneable);
        }
        Element element2 = element.getChild("properties");
        if (element2 != null) {
            for (Cloneable cloneable : element2.getAttributes()) {
                this.props.setProperty(cloneable.getName(), cloneable.getValue());
            }
        }
    }

    @Override
    public Element toXML(Element element) {
        Element element2 = Xml.addStorable(element, "brain", this);
        for (NeuralNet object : this.nets) {
            object.toXML(element2);
        }
        for (PatternSet patternSet : this.patternSets) {
            patternSet.toXML(element2);
        }
        Iterator<Cloneable> iterator = Xml.addChildTo(element2, "properties", null);
        for (Map.Entry<Object, Object> entry : this.props.entrySet()) {
            iterator.setAttribute(entry.getKey().toString(), entry.getValue().toString());
        }
        return element2;
    }
}

