/*
 * Created on Jul 8, 2008
 */
package xml;

import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;

import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class Parser {

	public static DefaultHandler parseFile(String filename, DefaultHandler handler,
			boolean validating, boolean nameSpaceAware) {
        // Use the default (non-validating) parser
        SAXParserFactory factory = SAXParserFactory.newInstance();        
        //System.out.println("Parser factory: " + factory.getClass().getCanonicalName());
        factory.setValidating(validating);
        factory.setNamespaceAware(nameSpaceAware);
        try {
             // Parse the input
            SAXParser saxParser = factory.newSAXParser();
            //System.out.println("Parser implementation: " + saxParser.getClass().getCanonicalName());
            saxParser.parse(new File(filename), handler);
                        
        } catch (SAXParseException spe) {
        	// Error generated by the parser
        	System.err.println("\n** Parsing error" 
        			+ ", line " + spe.getLineNumber()
					+ ", uri " + spe.getSystemId());
        	System.err.println("   " + spe.getMessage() );
        } catch (Throwable e) {
        	e.printStackTrace();
        }
		return handler;		
	}
	
	public static String parseString(String xmlDocument, WriterHandler handler,
			boolean validating, boolean nameSpaceAware) {
		// store a copy before you change the outWriter of the handler
		Writer backup = handler.getOutWriter();		
		StringWriter outWriter = new StringWriter();
		handler.setOutWriter(outWriter);
		// parse
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(validating);
        factory.setNamespaceAware(nameSpaceAware);
        try {
             // Parse the input
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(new InputSource(new StringReader(xmlDocument)), handler);
                        
        } catch (SAXParseException spe) {
        	// Error generated by the parser
        	System.err.println("\n** Parsing error" 
        			+ ", line " + spe.getLineNumber()
					+ ", uri " + spe.getSystemId());
        	System.err.println("   " + spe.getMessage() );
        } catch (Throwable e) {
        	e.printStackTrace();
        }
        handler.setOutWriter(backup);
		return outWriter.toString();		
	}
	
}
