# This script runs the xmlmatching experiments. The data needs to
# reside in a database (run "./load.sh" before this script).  The
# database parameters (host,name,user,password) are configured in the
# file "./config.txt".
#
# The results are written to log files.

# set java class path
oldclasspath=${CLASSPATH}
CLASSPATH=.
for i in lib/*.jar ; do CLASSPATH=${CLASSPATH}:${i} ; done

# for each data set
for source in dblp sprot treebank
do
    # configuration
    inForest=T${source}Sfr      # read original forest here
    outForest=T${source}Sf_ed  # create noisy forest here

    # match with different matching algorithms (nn, lg, gg)
    for matchingAlgo in nn # lg gg
    do
	# choose random edit opertion (delren, del, ren)
	for editop in delren # del ren
	do
	    echo "=== edit opertion: ${editop} ==="    
	    outfile=log/${source}/${editop}_${matchingAlgo}.log
	    echo "computing ${outfile}"
            java executable.ThresholdJoin ${inForest} ${outForest} \
		Np2q3 ${matchingAlgo} 20 ${editop} \
		> ${outfile}
	done
    done
    # choose random edit opertion (delren, del, ren)
    for editop in delren # del ren
    do
	echo "=== edit opertion: ${editop} ==="    
	# threshold matching with differen thresholds
	for tau in  0.3 0.5 0.7 ; do
	    outfile=log/${source}/${editop}_tau${tau}.log
	    echo "computing ${outfile}"
            java executable.ThresholdJoin ${inForest} ${outForest} \
		Np2q3 tau${tau} 20 ${editop} \
		> ${outfile}
	done
    done
done

# restore java classpath
CLASSPATH=${oldclasspath}
