# This script runs the street matchting experiment.
# The results are written to log files.

# set java class path
oldclasspath=${CLASSPATH}
CLASSPATH=.
for i in lib/*.jar ; do CLASSPATH=${CLASSPATH}:${i} ; done

# configure
forest1=data/L.trees  # address trees
forest2=data/R.trees  # address trees
solution=data/matches-L-R # pairs of correct IDs between forest1 and forest2
logdir=log # directory where logfiles are written
matchingAlgo=nn # symmetric nearest neighbor matching
norm="N" # normalization (either "", "D", or "N")
echo "" > ${logdir}/streetmatching.log
for dist in ${norm}h ${norm}gk ${norm}bb ${norm}b ${norm}fwe2 ${norm}e ; do
    distmatrix=${logdir}/${dist}.dm
    echo "=== distance function: ${dist} ==="    
    java executable.MatchForests ${forest1} ${forest2} \
	${solution} ${distmatrix} ${dist} ${matchingAlgo} \
	>> ${logdir}/streetmatching.log
done
for dist in ${norm}p3q3 ${norm}p1q2 ${norm}p2q3 ; do
    distmatrix=${logdir}/${dist}.dm
    echo "=== distance function: ${dist} ==="    
    java executable.MatchForests ${forest1} ${forest2} \
	${solution} ${distmatrix} ${dist} ${matchingAlgo} \
	>> ${logdir}/streetmatching.log
done

# restore java classpath
CLASSPATH=${oldclasspath}
