# This script runs the scalability experiments. For some experiments
# the data needs to reside in a database (run "./load.sh" before this
# script).  The database parameters (host,name,user,password) are
# configured in the file "./config.txt".
#
# The results are written to log files.

# configuration
file1=data/tree0
file2=data/tree1
tbl1=tree0
tbl2=tree1

# set java class path
oldclasspath=${CLASSPATH}
CLASSPATH=.
for i in lib/*.jar ; do CLASSPATH=${CLASSPATH}:${i} ; done

# compare pq-gram distance with tree embedding distance
for distance in Np1q2 Np2q3 Np3q4 Ngk ; do 
    echo Log file: log/${distance}.log
    java -Xmx1g executable.MatchTrees ${file1} ${file2} 1 18 ${distance} > log/${distance}.log
done

# compare disk-based pq-gram algorithm with main memory tree edit distance
echo Log file: log/Np2q3_disk.log
java -Xmx1g executable.MatchTblTrees ${tbl1} ${tbl2} 1 18 2 3 > log/Np2q3_disk.log
distance=Ne
echo Log file: log/${distance}.log
java -Xmx12g executable.MatchTrees ${file1} ${file2} 1 13 ${distance} > log/${distance}.log

# restore java classpath
CLASSPATH=${oldclasspath}
