# This script creates a new database and loads the experimental data
# to the tables tree0 and tree1. The database parameters
# (host,name,user,password) are configured in the file "./config.txt".
#
# The progress of the script is written to a log file.

# configuration
tbl1=tree0
tbl2=tree1
file1=data/tree0
file2=data/tree1
logfile=log/load.log

echo "Log file: $logfile"

# set java class path
source config.txt

# set java class path
oldclasspath=${CLASSPATH}
CLASSPATH=.
for i in lib/*.jar ; do CLASSPATH=${CLASSPATH}:${i} ; done

# create database
echo Creating new mysql database \"${db}\" on \"${host}\"...
mysql -h ${host} -u ${user} -p${pwd} -e "create database ${db}"

# load trees to table
echo Loading trees...
java executable.LoadTreeFilesToTbl tree0 data/tree0_?? > ${logfile} && java executable.LoadTreeFilesToTbl tree1 data/tree1_?? >> ${logfile} && echo Done.

# restore classpath
CLASSPATH=${oldclasspath}
