/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.StringTokenizer;

public class NonRegisteringDriver
implements Driver {
    public static final boolean DEBUG = false;
    public static final boolean TRACE = false;

    public int getMajorVersion() {
        return NonRegisteringDriver.getMajorVersionInternal();
    }

    public int getMinorVersion() {
        return NonRegisteringDriver.getMinorVersionInternal();
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        if (info == null) {
            info = new Properties();
        }
        if (url != null && url.startsWith("jdbc:mysql://")) {
            info = this.parseURL(url, info);
        }
        DriverPropertyInfo hostProp = new DriverPropertyInfo("HOST", info.getProperty("HOST"));
        hostProp.required = true;
        hostProp.description = "Hostname of MySQL Server";
        DriverPropertyInfo portProp = new DriverPropertyInfo("PORT", info.getProperty("PORT", "3306"));
        portProp.required = false;
        portProp.description = "Port number of MySQL Server";
        DriverPropertyInfo dbProp = new DriverPropertyInfo("DBNAME", info.getProperty("DBNAME"));
        dbProp.required = false;
        dbProp.description = "Database name";
        DriverPropertyInfo userProp = new DriverPropertyInfo("user", info.getProperty("user"));
        userProp.required = true;
        userProp.description = "Username to authenticate as";
        DriverPropertyInfo passwordProp = new DriverPropertyInfo("password", info.getProperty("password"));
        passwordProp.required = true;
        passwordProp.description = "Password to use for authentication";
        DriverPropertyInfo autoReconnect = new DriverPropertyInfo("autoReconnect", info.getProperty("autoReconnect", "false"));
        autoReconnect.required = false;
        autoReconnect.choices = new String[]{"true", "false"};
        autoReconnect.description = "Should the driver try to re-establish bad connections?";
        DriverPropertyInfo maxReconnects = new DriverPropertyInfo("maxReconnects", info.getProperty("maxReconnects", "3"));
        maxReconnects.required = false;
        maxReconnects.description = "Maximum number of reconnects to attempt if autoReconnect is true";
        DriverPropertyInfo initialTimeout = new DriverPropertyInfo("initialTimeout", info.getProperty("initialTimeout", "2"));
        initialTimeout.required = false;
        initialTimeout.description = "Initial timeout (seconds) to wait between failed connections";
        DriverPropertyInfo profileSql = new DriverPropertyInfo("profileSql", info.getProperty("profileSql", "false"));
        profileSql.required = false;
        profileSql.choices = new String[]{"true", "false"};
        profileSql.description = "Trace queries and their execution/fetch times on STDERR (true/false) defaults to false";
        DriverPropertyInfo socketTimeout = new DriverPropertyInfo("socketTimeout", info.getProperty("socketTimeout", "0"));
        socketTimeout.required = false;
        socketTimeout.description = "Timeout on network socket operations (0 means no timeout)";
        DriverPropertyInfo useSSL = new DriverPropertyInfo("useSSL", info.getProperty("useSSL", "false"));
        useSSL.required = false;
        useSSL.choices = new String[]{"true", "false"};
        useSSL.description = "Use SSL when communicating with the server?";
        DriverPropertyInfo useCompression = new DriverPropertyInfo("useCompression", info.getProperty("useCompression", "false"));
        useCompression.required = false;
        useCompression.choices = new String[]{"true", "false"};
        useCompression.description = "Use zlib compression when communicating with the server?";
        DriverPropertyInfo paranoid = new DriverPropertyInfo("paranoid", info.getProperty("paranoid", "false"));
        paranoid.required = false;
        paranoid.choices = new String[]{"true", "false"};
        paranoid.description = "Expose sensitive information in error messages and clear data structures holding sensitiven data when possible?";
        DriverPropertyInfo useHostsInPrivileges = new DriverPropertyInfo("useHostsInPrivileges", info.getProperty("useHostsInPrivileges", "true"));
        useHostsInPrivileges.required = false;
        useHostsInPrivileges.choices = new String[]{"true", "false"};
        useHostsInPrivileges.description = "Add '@hostname' to users in DatabaseMetaData.getColumn/TablePrivileges()";
        DriverPropertyInfo interactiveClient = new DriverPropertyInfo("interactiveClient", info.getProperty("interactiveClient", "false"));
        interactiveClient.required = false;
        interactiveClient.choices = new String[]{"true", "false"};
        interactiveClient.description = "Set the CLIENT_INTERACTIVE flag, which tells MySQL to timeout connections based on INTERACTIVE_TIMEOUT instead of WAIT_TIMEOUT";
        DriverPropertyInfo useTimezone = new DriverPropertyInfo("useTimezone", info.getProperty("useTimezone", "false"));
        useTimezone.required = false;
        useTimezone.choices = new String[]{"true", "false"};
        useTimezone.description = "Convert time/date types between client and server timezones";
        DriverPropertyInfo serverTimezone = new DriverPropertyInfo("serverTimezone", info.getProperty("serverTimezone", ""));
        serverTimezone.required = false;
        serverTimezone.description = "Override detection/mapping of timezone. Used when timezone from server doesn't map to Java timezone";
        DriverPropertyInfo connectTimeout = new DriverPropertyInfo("connectTimeout", info.getProperty("connectTimeout", "0"));
        connectTimeout.required = false;
        connectTimeout.description = "Timeout for socket connect (in milliseconds), with 0 being no timeout. Only works on JDK-1.4 or newer. Defaults to '0'.";
        DriverPropertyInfo queriesBeforeRetryMaster = new DriverPropertyInfo("queriesBeforeRetryMaster", info.getProperty("queriesBeforeRetryMaster", "50"));
        queriesBeforeRetryMaster.required = false;
        queriesBeforeRetryMaster.description = "Number of queries to issue before falling back to master when failed over (when using multi-host failover). Whichever condition is met first, 'queriesBeforeRetryMaster' or 'secondsBeforeRetryMaster' will cause an attempt to be made to reconnect to the master. Defaults to 50.";
        DriverPropertyInfo secondsBeforeRetryMaster = new DriverPropertyInfo("secondsBeforeRetryMaster", info.getProperty("secondsBeforeRetryMaster", "30"));
        secondsBeforeRetryMaster.required = false;
        secondsBeforeRetryMaster.description = "How long should the driver wait, when failed over, before attempting to reconnect to the master server? Whichever condition is met first, 'queriesBeforeRetryMaster' or 'secondsBeforeRetryMaster' will cause an attempt to be made to reconnect to the master. Time in seconds, defaults to 30";
        DriverPropertyInfo useStreamLengthsInPrepStmts = new DriverPropertyInfo("useStreamLengthsInPrepStmts", info.getProperty("useStreamLengthsInPrepStmts", "true"));
        useStreamLengthsInPrepStmts.required = false;
        useStreamLengthsInPrepStmts.choices = new String[]{"true", "false"};
        useStreamLengthsInPrepStmts.description = "Honor stream length parameter in PreparedStatement/ResultSet.setXXXStream() method calls (defaults to 'true')";
        DriverPropertyInfo continueBatchOnError = new DriverPropertyInfo("continueBatchOnError", info.getProperty("continueBatchOnError", "true"));
        continueBatchOnError.required = false;
        continueBatchOnError.choices = new String[]{"true", "false"};
        continueBatchOnError.description = "Should the driver continue processing batch commands if one statement fails. The JDBC spec allows either way (defaults to 'true').";
        DriverPropertyInfo allowLoadLocalInfile = new DriverPropertyInfo("allowLoadLocalInfile", info.getProperty("allowLoadLocalInfile", "true"));
        allowLoadLocalInfile.required = false;
        allowLoadLocalInfile.choices = new String[]{"true", "false"};
        allowLoadLocalInfile.description = "Should the driver allow use of 'LOAD DATA LOCAL INFILE...' (defaults to 'true').";
        DriverPropertyInfo strictUpdates = new DriverPropertyInfo("strictUpdates", info.getProperty("strictUpdates", "true"));
        strictUpdates.required = false;
        strictUpdates.choices = new String[]{"true", "false"};
        strictUpdates.description = "Should the driver do strict checking (all primary keys selected) of updatable result sets?...' (defaults to 'true').";
        DriverPropertyInfo ignoreNonTxTables = new DriverPropertyInfo("ignoreNonTxTables", info.getProperty("ignoreNonTxTables", "false"));
        ignoreNonTxTables.required = false;
        ignoreNonTxTables.choices = new String[]{"true", "false"};
        ignoreNonTxTables.description = "Ignore non-transactional table warning for rollback? (defaults to 'false').";
        DriverPropertyInfo clobberStreamingResults = new DriverPropertyInfo("clobberStreamingResults", info.getProperty("clobberStreamingResults", "false"));
        clobberStreamingResults.required = false;
        clobberStreamingResults.choices = new String[]{"true", "false"};
        clobberStreamingResults.description = "This will cause a 'streaming' ResultSet to be automatically closed, and any oustanding data still streaming from the server to be discarded if another query is executed before all the data has been read from the server.";
        DriverPropertyInfo reconnectAtTxEnd = new DriverPropertyInfo("reconnectAtTxEnd", info.getProperty("reconnectAtTxEnd", "false"));
        reconnectAtTxEnd.required = false;
        reconnectAtTxEnd.choices = new String[]{"true", "false"};
        reconnectAtTxEnd.description = "If autoReconnect is set to true, should the driver attempt reconnectionsat the end of every transaction? (true/false, defaults to false)";
        DriverPropertyInfo alwaysClearStream = new DriverPropertyInfo("alwaysClearStream", info.getProperty("alwaysClearStream", "false"));
        alwaysClearStream.required = false;
        alwaysClearStream.choices = new String[]{"true", "false"};
        alwaysClearStream.description = "Should the driver clear any remaining data from the input stream before issuing a query? Normally not needed (approx 1-2%\tperf. penalty, true/false, defaults to false)";
        DriverPropertyInfo cachePrepStmts = new DriverPropertyInfo("cachePrepStmts", info.getProperty("cachePrepStmts", "false"));
        cachePrepStmts.required = false;
        cachePrepStmts.choices = new String[]{"true", "false"};
        cachePrepStmts.description = "Should the driver cache the parsing stage of PreparedStatements (true/false, default is 'false')";
        DriverPropertyInfo prepStmtCacheSize = new DriverPropertyInfo("prepStmtCacheSize", info.getProperty("prepStmtCacheSize", "25"));
        prepStmtCacheSize.required = false;
        prepStmtCacheSize.description = "If prepared statement caching is enabled, how many prepared statements should be cached? (default is '25')";
        DriverPropertyInfo prepStmtCacheSqlLimit = new DriverPropertyInfo("prepStmtCacheSqlLimit", info.getProperty("prepStmtCacheSqlLimit", "256"));
        prepStmtCacheSqlLimit.required = false;
        prepStmtCacheSqlLimit.description = "If prepared statement caching is enabled, what's the largest SQL the driver will cache the parsing for? (in chars, default is '256')";
        DriverPropertyInfo useUnbufferedInput = new DriverPropertyInfo("useUnbufferedInput", info.getProperty("useUnbufferedInput", "true"));
        useUnbufferedInput.required = false;
        useUnbufferedInput.description = "Don't use BufferedInputStream for reading data from the server true/false (default is 'true')";
        DriverPropertyInfo[] dpi = new DriverPropertyInfo[]{hostProp, portProp, dbProp, userProp, passwordProp, autoReconnect, maxReconnects, initialTimeout, profileSql, socketTimeout, useSSL, paranoid, useHostsInPrivileges, interactiveClient, useCompression, useTimezone, serverTimezone, connectTimeout, secondsBeforeRetryMaster, queriesBeforeRetryMaster, useStreamLengthsInPrepStmts, continueBatchOnError, allowLoadLocalInfile, strictUpdates, ignoreNonTxTables, reconnectAtTxEnd, alwaysClearStream, cachePrepStmts, prepStmtCacheSize, prepStmtCacheSqlLimit, useUnbufferedInput};
        return dpi;
    }

    public boolean acceptsURL(String url) throws SQLException {
        return this.parseURL(url, null) != null;
    }

    public java.sql.Connection connect(String url, Properties info) throws SQLException {
        Properties props = null;
        props = this.parseURL(url, info);
        if (props == null) {
            return null;
        }
        try {
            Connection newConn = new Connection(this.host(props), this.port(props), props, this.database(props), url, this);
            return newConn;
        }
        catch (SQLException sqlEx) {
            throw sqlEx;
        }
        catch (Exception ex) {
            throw new SQLException("Cannot load connection class because of underlying exception: '" + ex.toString() + "'.", "08001");
        }
    }

    public String database(Properties props) {
        return props.getProperty("DBNAME");
    }

    public String host(Properties props) {
        return props.getProperty("HOST", "localhost");
    }

    public boolean jdbcCompliant() {
        return false;
    }

    public int port(Properties props) {
        return Integer.parseInt(props.getProperty("PORT", "3306"));
    }

    public String property(String name, Properties props) {
        return props.getProperty(name);
    }

    static int getMajorVersionInternal() {
        return NonRegisteringDriver.safeIntParse("3");
    }

    static int getMinorVersionInternal() {
        return NonRegisteringDriver.safeIntParse("0");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Properties parseURL(String url, Properties defaults) throws SQLException {
        StringTokenizer st;
        Properties urlProps = new Properties(defaults);
        if (url == null) {
            return null;
        }
        int index = url.indexOf("?");
        if (index != -1) {
            String paramString = url.substring(index + 1, url.length());
            url = url.substring(0, index);
            StringTokenizer queryParams = new StringTokenizer(paramString, "&");
            while (queryParams.hasMoreTokens()) {
                StringTokenizer vp = new StringTokenizer(queryParams.nextToken(), "=");
                String param = "";
                if (vp.hasMoreTokens()) {
                    param = vp.nextToken();
                }
                String value = "";
                if (vp.hasMoreTokens()) {
                    value = vp.nextToken();
                }
                if (value.length() <= 0 || param.length() <= 0) continue;
                urlProps.put(param, value);
            }
        }
        if (!(st = new StringTokenizer(url, ":/", true)).hasMoreTokens()) return null;
        String protocol = st.nextToken();
        if (protocol == null) return null;
        if (!protocol.equalsIgnoreCase("jdbc")) {
            return null;
        }
        if (!st.hasMoreTokens()) return null;
        String colon = st.nextToken();
        if (colon == null) return null;
        if (!colon.equals(":")) {
            return null;
        }
        if (!st.hasMoreTokens()) return null;
        String subProto = st.nextToken();
        if (subProto == null) return null;
        if (!subProto.equalsIgnoreCase("mysql")) {
            return null;
        }
        if (!st.hasMoreTokens()) return null;
        colon = st.nextToken();
        if (colon == null) return null;
        if (!colon.equals(":")) {
            return null;
        }
        if (!st.hasMoreTokens()) return null;
        String slash = st.nextToken();
        String slash2 = "";
        if (st.hasMoreTokens()) {
            slash2 = st.nextToken();
        }
        if (slash == null || slash2 == null) return null;
        if (!slash.equals("/") && !slash2.equals("/")) {
            return null;
        }
        if (!st.hasMoreTokens()) return null;
        String token = st.nextToken();
        if (token == null) return null;
        if (!token.equals(":") && !token.equals("/")) {
            urlProps.put("HOST", token);
            if (!st.hasMoreTokens()) return null;
            token = st.nextToken();
        }
        if (token.equals(":") && st.hasMoreTokens()) {
            token = st.nextToken();
            urlProps.put("PORT", token);
            if (st.hasMoreTokens()) {
                token = st.nextToken();
            }
        }
        if (!token.equals("/")) return urlProps;
        if (st.hasMoreTokens()) {
            token = st.nextToken();
            urlProps.put("DBNAME", token);
            return urlProps;
        }
        urlProps.put("DBNAME", "");
        return urlProps;
    }

    private static int safeIntParse(String intAsString) {
        try {
            return Integer.parseInt(intAsString);
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    static {
        DEBUG = false;
        TRACE = false;
    }
}

