/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CharsetMapping {
    public static final Map JAVA_TO_MYSQL_CHARSET_MAP;
    public static final Map CHARSETMAP;
    public static final Map MULTIBYTE_CHARSETS;
    public static final String[] INDEX_TO_CHARSET;

    static {
        HashMap<String, String> tempMap = new HashMap<String, String>();
        tempMap.put("usa7", "US-ASCII");
        tempMap.put("big5", "Big5");
        tempMap.put("gbk", "GBK");
        tempMap.put("sjis", "SJIS");
        tempMap.put("gb2312", "EUC_CN");
        tempMap.put("ujis", "EUC_JP");
        tempMap.put("euc_kr", "EUC_KR");
        tempMap.put("latin1", "ISO8859_1");
        tempMap.put("latin1_de", "ISO8859_1");
        tempMap.put("german1", "ISO8859_1");
        tempMap.put("danish", "ISO8859_1");
        tempMap.put("latin2", "ISO8859_2");
        tempMap.put("czech", "ISO8859_2");
        tempMap.put("hungarian", "ISO8859_2");
        tempMap.put("croat", "ISO8859_2");
        tempMap.put("greek", "ISO8859_7");
        tempMap.put("hebrew", "ISO8859_8");
        tempMap.put("latin5", "ISO8859_9");
        tempMap.put("latvian", "ISO8859_13");
        tempMap.put("latvian1", "ISO8859_13");
        tempMap.put("estonia", "ISO8859_13");
        tempMap.put("dos", "Cp437");
        tempMap.put("pclatin2", "Cp852");
        tempMap.put("cp866", "Cp866");
        tempMap.put("koi8_ru", "KOI8_R");
        tempMap.put("tis620", "TIS620");
        tempMap.put("win1250", "Cp1250");
        tempMap.put("win1250ch", "Cp1250");
        tempMap.put("win1251", "Cp1251");
        tempMap.put("cp1251", "Cp1251");
        tempMap.put("win1251ukr", "Cp1251");
        tempMap.put("cp1257", "Cp1257");
        tempMap.put("macroman", "MacRoman");
        tempMap.put("macce", "MacCentralEurope");
        tempMap.put("utf8", "UTF-8");
        tempMap.put("ucs2", "UnicodeBig");
        CHARSETMAP = Collections.unmodifiableMap(tempMap);
        HashMap javaToMysqlMap = new HashMap();
        Set keySet = CHARSETMAP.keySet();
        Iterator keys = keySet.iterator();
        while (keys.hasNext()) {
            Object mysqlEncodingName = keys.next();
            Object javaEncodingName = CHARSETMAP.get(mysqlEncodingName);
            if ("ISO8859_1".equals(javaEncodingName)) {
                if (!"latin1".equals(mysqlEncodingName)) continue;
                javaToMysqlMap.put(javaEncodingName, mysqlEncodingName);
                continue;
            }
            if ("ISO8859_2".equals(javaEncodingName)) {
                if (!"latin2".equals(mysqlEncodingName)) continue;
                javaToMysqlMap.put(javaEncodingName, mysqlEncodingName);
                continue;
            }
            if ("ISO8859_13".equals(javaEncodingName)) {
                if (!"latin7".equals(mysqlEncodingName)) continue;
                javaToMysqlMap.put(javaEncodingName, mysqlEncodingName);
                continue;
            }
            javaToMysqlMap.put(javaEncodingName, mysqlEncodingName);
        }
        JAVA_TO_MYSQL_CHARSET_MAP = Collections.unmodifiableMap(javaToMysqlMap);
        HashMap<String, String> tempMapMulti = new HashMap<String, String>();
        tempMapMulti.put("big5", "big5");
        tempMapMulti.put("euc_kr", "euc_kr");
        tempMapMulti.put("gb2312", "gb2312");
        tempMapMulti.put("gbk", "gbk");
        tempMapMulti.put("sjis", "sjis");
        tempMapMulti.put("ujis", "ujist");
        tempMapMulti.put("utf8", "utf8");
        tempMapMulti.put("ucs2", "UnicodeBig");
        MULTIBYTE_CHARSETS = Collections.unmodifiableMap(tempMapMulti);
        INDEX_TO_CHARSET = new String[64];
        CharsetMapping.INDEX_TO_CHARSET[1] = (String)CHARSETMAP.get("big5");
        CharsetMapping.INDEX_TO_CHARSET[2] = (String)CHARSETMAP.get("\tczech");
        CharsetMapping.INDEX_TO_CHARSET[3] = (String)CHARSETMAP.get("dec8");
        CharsetMapping.INDEX_TO_CHARSET[4] = (String)CHARSETMAP.get("dos");
        CharsetMapping.INDEX_TO_CHARSET[5] = (String)CHARSETMAP.get("german1");
        CharsetMapping.INDEX_TO_CHARSET[6] = (String)CHARSETMAP.get("hp8");
        CharsetMapping.INDEX_TO_CHARSET[7] = (String)CHARSETMAP.get("koi8_ru");
        CharsetMapping.INDEX_TO_CHARSET[8] = (String)CHARSETMAP.get("latin1");
        CharsetMapping.INDEX_TO_CHARSET[9] = (String)CHARSETMAP.get("latin2");
        CharsetMapping.INDEX_TO_CHARSET[10] = (String)CHARSETMAP.get("swe7");
        CharsetMapping.INDEX_TO_CHARSET[11] = (String)CHARSETMAP.get("usa7");
        CharsetMapping.INDEX_TO_CHARSET[12] = (String)CHARSETMAP.get("ujis");
        CharsetMapping.INDEX_TO_CHARSET[13] = (String)CHARSETMAP.get("sjis");
        CharsetMapping.INDEX_TO_CHARSET[14] = (String)CHARSETMAP.get("cp1251");
        CharsetMapping.INDEX_TO_CHARSET[15] = (String)CHARSETMAP.get("danish");
        CharsetMapping.INDEX_TO_CHARSET[16] = (String)CHARSETMAP.get("hebrew");
        CharsetMapping.INDEX_TO_CHARSET[18] = (String)CHARSETMAP.get("tis620");
        CharsetMapping.INDEX_TO_CHARSET[19] = (String)CHARSETMAP.get("euc_kr");
        CharsetMapping.INDEX_TO_CHARSET[20] = (String)CHARSETMAP.get("estonia");
        CharsetMapping.INDEX_TO_CHARSET[21] = (String)CHARSETMAP.get("hungarian");
        CharsetMapping.INDEX_TO_CHARSET[22] = (String)CHARSETMAP.get("koi8_ukr");
        CharsetMapping.INDEX_TO_CHARSET[23] = (String)CHARSETMAP.get("win1251ukr");
        CharsetMapping.INDEX_TO_CHARSET[24] = (String)CHARSETMAP.get("gb2312");
        CharsetMapping.INDEX_TO_CHARSET[25] = (String)CHARSETMAP.get("greek");
        CharsetMapping.INDEX_TO_CHARSET[26] = (String)CHARSETMAP.get("win1250");
        CharsetMapping.INDEX_TO_CHARSET[27] = (String)CHARSETMAP.get("croat");
        CharsetMapping.INDEX_TO_CHARSET[28] = (String)CHARSETMAP.get("gbk");
        CharsetMapping.INDEX_TO_CHARSET[29] = (String)CHARSETMAP.get("cp1257");
        CharsetMapping.INDEX_TO_CHARSET[30] = (String)CHARSETMAP.get("latin5");
        CharsetMapping.INDEX_TO_CHARSET[31] = (String)CHARSETMAP.get("latin1_de");
        CharsetMapping.INDEX_TO_CHARSET[32] = (String)CHARSETMAP.get("armscii8");
        CharsetMapping.INDEX_TO_CHARSET[33] = (String)CHARSETMAP.get("utf8");
        CharsetMapping.INDEX_TO_CHARSET[34] = (String)CHARSETMAP.get("win1250ch");
        CharsetMapping.INDEX_TO_CHARSET[35] = (String)CHARSETMAP.get("ucs2");
        CharsetMapping.INDEX_TO_CHARSET[36] = (String)CHARSETMAP.get("cp866");
        CharsetMapping.INDEX_TO_CHARSET[37] = (String)CHARSETMAP.get("keybcs2");
        CharsetMapping.INDEX_TO_CHARSET[38] = (String)CHARSETMAP.get("macce");
        CharsetMapping.INDEX_TO_CHARSET[39] = (String)CHARSETMAP.get("macroman");
        CharsetMapping.INDEX_TO_CHARSET[40] = (String)CHARSETMAP.get("pclatin2");
        CharsetMapping.INDEX_TO_CHARSET[41] = (String)CHARSETMAP.get("latvian");
        CharsetMapping.INDEX_TO_CHARSET[42] = (String)CHARSETMAP.get("latvian1");
        CharsetMapping.INDEX_TO_CHARSET[43] = (String)CHARSETMAP.get("maccebin");
        CharsetMapping.INDEX_TO_CHARSET[44] = (String)CHARSETMAP.get("macceciai");
        CharsetMapping.INDEX_TO_CHARSET[45] = (String)CHARSETMAP.get("maccecias");
        CharsetMapping.INDEX_TO_CHARSET[46] = (String)CHARSETMAP.get("maccecsas");
        CharsetMapping.INDEX_TO_CHARSET[47] = (String)CHARSETMAP.get("latin1bin");
        CharsetMapping.INDEX_TO_CHARSET[48] = (String)CHARSETMAP.get("latin1cias");
        CharsetMapping.INDEX_TO_CHARSET[49] = (String)CHARSETMAP.get("latin1csas");
        CharsetMapping.INDEX_TO_CHARSET[50] = (String)CHARSETMAP.get("cp1251bin");
        CharsetMapping.INDEX_TO_CHARSET[51] = (String)CHARSETMAP.get("cp1251cias");
        CharsetMapping.INDEX_TO_CHARSET[52] = (String)CHARSETMAP.get("cp1251csas");
        CharsetMapping.INDEX_TO_CHARSET[53] = (String)CHARSETMAP.get("macromanbin");
        CharsetMapping.INDEX_TO_CHARSET[54] = (String)CHARSETMAP.get("macromancias");
        CharsetMapping.INDEX_TO_CHARSET[55] = (String)CHARSETMAP.get("macromanciai");
        CharsetMapping.INDEX_TO_CHARSET[56] = (String)CHARSETMAP.get("macromancsas");
        CharsetMapping.INDEX_TO_CHARSET[57] = (String)CHARSETMAP.get("cp1256");
        CharsetMapping.INDEX_TO_CHARSET[63] = (String)CHARSETMAP.get("binary");
    }
}

